#!/bin/bash
export datasets="wikics"
export missing_rates="0.999 0.9999 1.0"
export missing_rates_test="0.1 0.5 0.999"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export k_list="2"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=3

# uniform
for missing_rate in $missing_rates
do
for lamb in 1e-5 1e-4 1e-3 1e-2 1e-1 1e+0
do
python main.py --dataset wikics --missing_type uniform --lamb ${lamb} --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 10 --gpu ${gpu} --k 4
done
done


# uniform
for missing_rate in $missing_rates_test
do
for lamb in 1e-5 1e-4 1e-3 1e-2 1e-1 1e+0
do
python main.py --dataset cs --missing_type uniform --lamb ${lamb} --lp_temp 1.0 --missing_rate ${missing_rate}  --embedder GOODIE --filling_method fp --n_runs 10 --gpu ${gpu} --k 1
done
done